<?php
if(CheckIfPathRouteIsInTheDB('delivery')){
    createRoute('delivery', 'modulus/inc/delivery/views/dashboard/delivery.php', 'dashboard');
}

if(CheckIfPathRouteIsInTheDB('pickups')){
    createRoute('pickups', 'modulus/inc/delivery/views/dashboard/pickups.php', 'dashboard');
}

if(CheckIfPathRouteIsInTheDB('schedule')){
    createRoute('schedule', 'modulus/inc/delivery/views/dashboard/schedule.php', 'dashboard');
}


function getAllOfTheDeliveryByDate($date){
    global $conn;
    $results = $conn->prepare("SELECT * FROM `ORDERDETAILS` WHERE `DELIVERY_DATE` = :date AND `STATUS` = 'Reservation'  AND `DELIVERY_OPTION` = 'delivery'  OR `DELIVERY_DATE` = :date AND `STATUS` = 'delivered'  AND `DELIVERY_OPTION` = 'delivery'  ORDER BY `DELIVERY_TIME_END` ASC");
    $results->bindParam(':date', $date);
    $results->execute();
    return $results;
}

function  getAllOfThePickupsByDate($date){
    global $conn;
    $results = $conn->prepare("SELECT * FROM `ORDERDETAILS` WHERE `PICKUP_DATE` = :date AND `STATUS` = 'delivered' AND `DELIVERY_OPTION` = 'delivery' OR `PICKUP_DATE` = :date AND `STATUS` = 'completed'  AND `DELIVERY_OPTION` = 'delivery'  ORDER BY `PICKUP_TIME_END` ASC");
    $results->bindParam(':date', $date);
    $results->execute();
    return $results;
}

function  getAllOfThePickupsandDelivriesByDate($date){
    global $conn;
    $results = $conn->prepare("SELECT * FROM `ORDERDETAILS` WHERE `PICKUP_DATE` = :date AND `STATUS` = 'delivered' AND `DELIVERY_OPTION` = 'delivery' OR `PICKUP_DATE` = :date AND `STATUS` = 'completed'  AND `DELIVERY_OPTION` = 'delivery' OR `DELIVERY_DATE` = :date AND `STATUS` = 'Reservation'  AND `DELIVERY_OPTION` = 'delivery'  OR `DELIVERY_DATE` = :date AND `STATUS` = 'delivered'  AND `DELIVERY_OPTION` = 'delivery' ORDER BY `ID` ASC");
    $results->bindParam(':date', $date);
    $results->execute();
    return $results;
}

# Setting Function
function ChangeOrderStatusToDeliveredById($id){
    global $conn;
    $results = $conn->prepare("UPDATE
        `ORDERDETAILS`
    SET
        `STATUS` = 'delivered'
    WHERE
        `ID` = :id
    ");
    $results->bindParam(':id', $id);
    $results->execute();
    return $results; 
}

# Setting Function
function ChangeOrderStatusToCompletedById($id){
    global $conn;
    $results = $conn->prepare("UPDATE
        `ORDERDETAILS`
    SET
        `STATUS` = 'completed'
    WHERE
        `ID` = :id
    ");
    $results->bindParam(':id', $id);
    $results->execute();
    return $results; 
}
function getAllOfTheDeliveryByDateAndTruck($date, $truck){
    global $conn;
    $results = $conn->prepare("SELECT * FROM `ORDERDETAILS` WHERE `DELIVERY_DATE` = :date AND `STATUS` = 'Reservation'  AND `DELIVERY_OPTION` = 'delivery' AND `ASSIGNMENT` = :truck OR `DELIVERY_DATE` = :date AND `STATUS` = 'delivered'  AND `DELIVERY_OPTION` = 'delivery' AND `ASSIGNMENT` = :truck ORDER BY `DELIVERY_TIME_END` ASC");
    $results->bindParam(':date', $date);
    $results->bindParam(':truck', $truck);
    $results->execute();
    return $results;
}

function getAllOfThePickupByDateAndTruck($date, $truck){
    global $conn;
    $results = $conn->prepare("SELECT * FROM `ORDERDETAILS` WHERE `PICKUP_DATE` = :date AND `STATUS` = 'delivered'  AND `DELIVERY_OPTION` = 'delivery' AND `ASSIGNMENT` = :truck OR `PICKUP_DATE` = :date AND `STATUS` = 'completed'  AND `DELIVERY_OPTION` = 'delivery' AND `ASSIGNMENT` = :truck ORDER BY `PICKUP_TIME_END` ASC");
    $results->bindParam(':date', $date);
    $results->bindParam(':truck', $truck);
    $results->execute();
    return $results;
}
function getAllOfThePickupsandDelivriesByDateAndTruck($date, $truck){
    global $conn;
    $results = $conn->prepare("SELECT * FROM `ORDERDETAILS` WHERE `PICKUP_DATE` = :date AND `STATUS` = 'delivered'  AND `DELIVERY_OPTION` = 'delivery' AND `ASSIGNMENT` = :truck OR `PICKUP_DATE` = :date AND `STATUS` = 'completed'  AND `DELIVERY_OPTION` = 'delivery' AND `ASSIGNMENT` = :truck OR `DELIVERY_DATE` = :date AND `STATUS` = 'Reservation'  AND `DELIVERY_OPTION` = 'delivery' AND `ASSIGNMENT` = :truck OR `DELIVERY_DATE` = :date AND `STATUS` = 'delivered'  AND `DELIVERY_OPTION` = 'delivery' AND `ASSIGNMENT` = :truck  ORDER BY `ID` ASC");
    $results->bindParam(':date', $date);
    $results->bindParam(':truck', $truck);
    $results->execute();
    return $results;
}
function getQuantityByDate($date, $inventory_id){
    global $conn;
    $results = $conn->prepare(
        "SELECT
            SUM(ORDER_ITEMS.QUANTITY)
        FROM
            ORDER_ITEMS
        INNER JOIN ORDERDETAILS ON ORDER_ITEMS.ORDERDETAILS_ID = ORDERDETAILS.ID
        WHERE
            ORDER_ITEMS.INVENTORY_ID = :inventory_id AND ORDERDETAILS.DELIVERY_DATE = :date AND ORDERDETAILS.STATUS = 'Reservation'
        ");
    $results->bindParam(':date', $date);
    $results->bindParam(':inventory_id', $inventory_id);
    $results->execute();
    $quantity = $results->fetch(PDO::FETCH_NUM);
    return $quantity[0];
}
function getQuantityByDatePickup($date, $inventory_id){
    global $conn;
    $results = $conn->prepare(
        "SELECT
            SUM(ORDER_ITEMS.QUANTITY)
        FROM
            ORDER_ITEMS
        INNER JOIN ORDERDETAILS ON ORDER_ITEMS.ORDERDETAILS_ID = ORDERDETAILS.ID
        WHERE
            ORDER_ITEMS.INVENTORY_ID = :inventory_id AND ORDERDETAILS.PICKUP_DATE = :date AND ORDERDETAILS.STATUS = 'delivered'
        ");
    $results->bindParam(':date', $date);
    $results->bindParam(':inventory_id', $inventory_id);
    $results->execute();
    $quantity = $results->fetch(PDO::FETCH_NUM);
    return $quantity[0];
}
function getQuantityByDateByTruck($date, $inventory_id, $truck_id){
    global $conn;
    $results = $conn->prepare(
        "SELECT
            SUM(ORDER_ITEMS.QUANTITY)
        FROM
            ORDER_ITEMS
        INNER JOIN ORDERDETAILS ON ORDER_ITEMS.ORDERDETAILS_ID = ORDERDETAILS.ID
        WHERE
            ORDER_ITEMS.INVENTORY_ID = :inventory_id AND ORDERDETAILS.DELIVERY_DATE = :date AND ORDERDETAILS.STATUS = 'Reservation' AND ORDERDETAILS.ASSIGNMENT = :truck_id
        ");
    $results->bindParam(':date', $date);
    $results->bindParam(':inventory_id', $inventory_id);
    $results->bindParam(':truck_id', $truck_id);
    $results->execute();
    $quantity = $results->fetch(PDO::FETCH_NUM);
    return $quantity[0];
}

function getQuantityByDateByTruckPickup($date, $inventory_id, $truck_id){
    global $conn;
    $results = $conn->prepare(
        "SELECT
            SUM(ORDER_ITEMS.QUANTITY)
        FROM
            ORDER_ITEMS
        INNER JOIN ORDERDETAILS ON ORDER_ITEMS.ORDERDETAILS_ID = ORDERDETAILS.ID
        WHERE
            ORDER_ITEMS.INVENTORY_ID = :inventory_id AND ORDERDETAILS.PICKUP_DATE = :date AND ORDERDETAILS.STATUS = 'delivered' AND ORDERDETAILS.ASSIGNMENT = :truck_id
        ");
    $results->bindParam(':date', $date);
    $results->bindParam(':inventory_id', $inventory_id);
    $results->bindParam(':truck_id', $truck_id);
    $results->execute();
    $quantity = $results->fetch(PDO::FETCH_NUM);
    return $quantity[0];
}

function getQuantityByDateByTruckPickupOnTheTruck($date, $inventory_id, $truck_id){
    global $conn;
    $results = $conn->prepare(
        "SELECT
            SUM(ORDER_ITEMS.QUANTITY)
        FROM
            ORDER_ITEMS
        INNER JOIN ORDERDETAILS ON ORDER_ITEMS.ORDERDETAILS_ID = ORDERDETAILS.ID
        WHERE
            ORDER_ITEMS.INVENTORY_ID = :inventory_id AND ORDERDETAILS.PICKUP_DATE = :date AND ORDERDETAILS.STATUS = 'completed' AND ORDERDETAILS.ASSIGNMENT = :truck_id
        ");
    $results->bindParam(':date', $date);
    $results->bindParam(':inventory_id', $inventory_id);
    $results->bindParam(':truck_id', $truck_id);
    $results->execute();
    $quantity = $results->fetch(PDO::FETCH_NUM);
    return $quantity[0];
}