<?php
// Dashboard Route Setup
if(CheckIfPathRouteIsInTheDB('editfaq')){
    createRoute('editfaq', 'modulus/inc/faqs/views/dashboard/editfaqs.php', 'dashboard');
}
if(CheckIfPathRouteIsInTheDB('createfaq')){
    createRoute('createfaq', 'modulus/inc/faqs/views/dashboard/createfaqs.php', 'dashboard');
}

if(tableExists('FAQ')== false){
    createfaqsTable();
}

// Create Reviews table in Database
function createfaqsTable(){
    global $conn;
    $sql="  CREATE TABLE `FAQ` (
            `ID` int(255) NOT NULL,
            `QUESTION` varchar(1000) NOT NULL,
            `ANSWER` varchar(10000) NOT NULL,
            `STATUS` varchar(255) NOT NULL,
            `ORGANIZATIONS_ID` int(255) NOT NULL
            ) ENGINE=MyISAM DEFAULT CHARSET=latin1;

            ALTER TABLE `FAQ`
                ADD PRIMARY KEY (`ID`);
            COMMIT;

            ALTER TABLE `FAQ`
                MODIFY `ID` int(255) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;
            COMMIT;

    ";
    $results = $conn->prepare($sql);
    $results->execute();
}

// Create A  FAQ
function createFAQ($question, $answer, $status, $org_id){
    global $conn;
    $results = $conn->prepare("INSERT INTO `FAQ`(`QUESTION`, `ANSWER`, `STATUS`, `ORGANIZATIONS_ID`) VALUES (:question,:answer,:status,:org_id)");
    $results->bindParam(':question', $question);
    $results->bindParam(':answer', $answer);
    $results->bindParam(':status', $status);
    $results->bindParam(':org_id', $org_id);
    $results->execute();
    $last_id = $conn->lastInsertId();

    return $last_id; 
}

// Update FAQS
function updateFAQ($id, $question, $answer, $status){
    global $conn;
    $results = $conn->prepare("UPDATE `FAQ` SET `QUESTION`= :question ,`ANSWER`= :answer ,`STATUS` = :status WHERE `ID` = :id");
    $results->bindParam(':question', $question);
    $results->bindParam(':answer', $answer);
    $results->bindParam(':status', $status);
    $results->bindParam(':id', $id);
    $results->execute();
    return $results; 
}

function getFaqItems($org_id){
    global $conn;
    $results = $conn->prepare("SELECT * FROM `FAQ` WHERE `STATUS` = 'active' AND `ORGANIZATIONS_ID` = :org_id");
    $results->bindParam(':org_id', $org_id);
    $results->execute();
    return $results; 
}

function getAllFaqItems($org_id){
    global $conn;
    $results = $conn->prepare("SELECT * FROM `FAQ` WHERE `ORGANIZATIONS_ID` = :org_id");
    $results->bindParam(':org_id', $org_id);
    $results->execute();
    return $results; 

}

function getAFaqQuestionByID($id){
    global $conn;
    $results = $conn->prepare("SELECT * FROM `FAQ` WHERE `ID` = :id");
    $results->bindParam(':id', $id);
    $results->execute();
    return $results; 

}