<?php
// Create table if Not Created
if(CheckIfPathRouteIsInTheDB('edituser')){
    createRoute('edituser', 'modulus/inc/users/views/dashboard/edituser.php', 'dashboard');
}
if(CheckIfPathRouteIsInTheDB('createuser')){
    createRoute('createuser', 'modulus/inc/users/views/dashboard/createuser.php', 'dashboard');
}
if(CheckIfPathRouteIsInTheDB('login')){
    createRoute('login', 'modulus/inc/users/views/login.php', 'users');
}
if(tableExists('USERS')== false){
    createUserTable();
}

// Create Reviews table in Database
function createUserTable(){
    global $conn;
    $sql="  CREATE TABLE `USERS` (
            `ID` int(255) NOT NULL,
            `NAME` varchar(255) NOT NULL,
            `EMAIL` varchar(255) NOT NULL,
            `PASSWORD` varchar(255) NOT NULL,
            `STATUS` varchar(255) NOT NULL,
            `ROLE` varchar(255) NOT NULL,
            `CREATED_DATE` varchar(255) NOT NULL
            ) ENGINE=MyISAM DEFAULT CHARSET=latin1;

            ALTER TABLE `USERS`
                ADD PRIMARY KEY (`ID`);
            COMMIT;

            ALTER TABLE `USERS`
                MODIFY `ID` int(255) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;
            COMMIT;

    ";
    $results = $conn->prepare($sql);
    $results->execute();
}
### Start User Signup, Login and Logout ###
# Create New users in the Database
function createNewUser($name, $email, $password, $role, $startSession){
    global $conn;
    
    $results = $conn->prepare("INSERT INTO USERS (`NAME`, `EMAIL`, `PASSWORD`, `STATUS`, `ROLE`,  `CREATED_DATE`) VALUES (:name, :email, :password, 'active', :role, :date)");

    $results->bindParam(':name', $name);

    $results->bindParam(':email', $email);

    $results->bindParam(':password', $password);

    $results->bindParam(':role', $role);

    $results->bindParam(':date', $date);
    
    $date = date("Y-m-d H:i:s");

    $results->execute();

    $last_id = $conn->lastInsertId();
    
    if($startSession == true){
        

        startSession($last_id);

    }
    
    return $last_id;
}

# Update users info in the Database
function updateUser($id, $name, $email, $status, $role){
    global $conn;
    
    $results = $conn->prepare("UPDATE `USERS` SET `NAME`=:name,`EMAIL`=:email, `STATUS`=:status,`ROLE`=:role WHERE `ID`= :id");

    $results->bindParam(':id', $id);

    $results->bindParam(':name', $name);

    $results->bindParam(':email', $email);

    $results->bindParam(':status', $status);

    $results->bindParam(':role', $role);

    $results->execute();

    return $id;
}

# Encript users Password
function encriptPassword($password){

    $Hashpassword = md5($password); 

    $DBpassword = crypt($Hashpassword, 'st');

    return $DBpassword;
}

# Check if User email is unique
function uniqueEmail($email){

    global $conn;

    $results = $conn->prepare("SELECT count(*) FROM `USERS` WHERE `EMAIL` = :email");
    
    $results->bindParam(':email', $email);
    
    $results->execute();

    $row = $results->fetchColumn();

    if($row < 1){
        return true;
    } else{
        return false;
    }
} 

# Check if a user password and email is correct
function login($email, $password){

    global $conn;

    $results = $conn->prepare("SELECT * FROM `USERS` WHERE `EMAIL` = :email AND `PASSWORD` = :password");
    
    $results->bindParam(':email', $email);

    $results->bindParam(':password', $password);

    $results->execute();

    $user_info = $results->fetch(PDO::FETCH_ASSOC);

    if(isset($user_info['ID'])){

        // endSession();

        startSession($user_info['ID']);

        return true;
        
    }else {

        return false;

    }

}

# Start Brower Seccion
function startSession($user_id){
    global $conn;

    $results = $conn->prepare("SELECT * FROM `USERS` WHERE `ID` = :id");
    
    $results->bindParam(':id', $user_id);
    
    $results->execute();

    $user_info = $results->fetch(PDO::FETCH_ASSOC);
     
    if(isset($_SESSION)){

    // endSession();

    }

    // session_start();

    $_SESSION["name"] = $user_info['NAME'];    
    $_SESSION["user_id"] = $user_info['ID'];
    $_SESSION["email"] = $user_info['EMAIL'];
    $_SESSION["status"] = $user_info['STATUS'];
    $_SESSION["role"] = $user_info['ROLE'];
    $_SESSION["created_date"] = $user_info['CREATED_DATE'];

    echo $_SESSION["role"];

    return;
}

# End Browser Session
function endSession(){
    // remove all session variables
    session_unset();

    // destroy the session
    session_destroy(); 
}

# Select all users in the Database
function getAllUsers(){
    global $conn;
    $results = $conn->prepare("SELECT * FROM `USERS`");
    $results->execute();

    return $results;    
}

# Select all users in the Database
function getAllAdminUsers(){
    global $conn;
    $results = $conn->prepare("SELECT * FROM `USERS` WHERE `ROLE` = 1");
    $results->execute();

    return $results;    
}

# Select a User in the Database
function getAUsers($id){
    global $conn;
    $results = $conn->prepare("SELECT * FROM `USERS` WHERE `ID` = :id ");
    $results->bindParam(':id', $id);
    $results->execute();
    $results = $results->fetch(PDO::FETCH_ASSOC);
    return $results;    
}

# Select a User Role Name in the Database
function getAUserName($id){
    global $conn;
    $results = $conn->prepare("SELECT * FROM `USERS` WHERE `ID` = :id ");
    $results->bindParam(':id', $id, PDO::PARAM_INT);
    $results->execute();
    $user = $results->fetch(PDO::FETCH_ASSOC);
    return $user['NAME'];    
}


## User Role ID Functions 
# Select a User Role ID in the Database
function getAUserRoleId($id){
    global $conn;
    $results = $conn->prepare("SELECT * FROM `USERS` WHERE `ID` = :id ");
    $results->bindParam(':id', $id);
    $results->execute();
    $role = $results->fetch(PDO::FETCH_ASSOC);
    return $role['ROLE'];    
}

# Select a User Role Name in the Database
function getAUserRoleName($id){
    global $conn;
    $results = $conn->prepare("SELECT * FROM `ROLES` WHERE `ID` = :id ");
    $results->bindParam(':id', $id);
    $results->execute();
    $role = $results->fetch(PDO::FETCH_ASSOC);
    return $role['NAME'];    
}

# Get all Users Roles
function getAllRole(){
    global $conn;
    $results = $conn->prepare("SELECT * FROM `ROLES`");
    $results->bindParam(':id', $id);
    $results->execute();
    return $results;    
}

# Update User Password
function updateUserPassword($id, $NewPassword){
    global $conn;

    $results = $conn->prepare("UPDATE `USERS` SET `Password`=:password WHERE `ID`= :id");

    $results->bindParam(':id', $id);

    $results->bindParam(':password', $NewPassword);

    $results->execute();

    return $id;
}   
