<?php 
include 'inc/stripe/init.php';
include 'functions.php';

$settings = getSettings(1);

if($settings['PAYMENT_MODE']== 'live'){
    // Set your secret key: remember to change this to your live secret key in production
    // See your keys here: https://dashboard.stripe.com/account/apikeys
    \Stripe\Stripe::setApiKey($settings['STRIPE_SECRET_KEY_LIVE']);
}else{
    // Set your secret key: remember to change this to your live secret key in production
    // See your keys here: https://dashboard.stripe.com/account/apikeys
    \Stripe\Stripe::setApiKey($settings['STRIPE_SECRET_KEY_TEST']);
}

// Token is created using Checkout or Elements!
// Get the payment token ID submitted by the form:
$token = $_POST['stripeToken'];
$price = $_GET['price'];
$paymentStatus = $_GET['paymentstatus'];
$orderdetails_id = $_GET['orderdetails_id'];
$organization_id = $_GET['org_id'];
$type = $_GET['type'];
$customerEmail = $_GET['customeremail'];
$customerName = $_GET['customername'];
$orderdetails_idDesc = $settings['INVOICE_PRE'].''.$orderdetails_id;
$transaction_id = $token;

$priceemail = number_format($price/100, 2);

$content = "
<h2>Payment Made: ".$orderdetails_idDesc."</h2>
    <p>Confirmation Number: ".$settings['INVOICE_PRE']."".$token."</p>
    <p>Amount: $".$priceemail."</p>
    <p>Date: ".date("Y-m-d H:i:s")."</p>
    <p>Payment Status: ".$paymentStatus."</p>
    <p>IP Address: ".getUserIpAddr()."</p>
    <p>Lead #: https://".$settings['DOMAIN']."/orders.php?orderid=00".$orderdetails_id."</p>

";

$customerContent = "
<h2>Payment Receipt : ".$orderdetails_idDesc."</h2>
<p>Confirmation Number: ".$settings['INVOICE_PRE']."".$token."</p>
<p>Amount: $".$priceemail."</p>
<p>Date: ".date("Y-m-d H:i:s")."</p>
<p>Payment Status: ".$paymentStatus."</p>
<p>Order #: <a href='https://".$settings['DOMAIN']."/orders.php?orderid=00".$orderdetails_id."'>".$orderdetails_idDesc."</a></p>

";
   
$subject = "New Payment $".$priceemail." for ".$settings['BUSINESS_NAME']."- Order: #".$orderdetails_idDesc;

$subjectDeclined = "New Failed Payment $".$priceemail." for ".$settings['BUSINESS_NAME']."- Order: #".$orderdetails_idDesc;

$CustomerSubject = "Recipt for Order: #".$orderdetails_idDesc." - ".$settings['BUSINESS_NAME']."";

if(isset($_POST['stripeToken'])){
    try {
        $charge = \Stripe\Charge::create([
            'amount' => $price,
            'currency' => 'usd',
            'description' => $orderdetails_idDesc,
            'source' => $token,
        ]);
        createaResavation($orderdetails_id,$paymentStatus);
        createAPayment($organization_id, $orderdetails_id, $transaction_id, $price, $type);

        sendEmail('kristy.g.jackson@gmail.com', 'Kristy Jackson', $subject, $content, "payments@katyrental.com", $settings['BUSINESS_NAME']);\
        sendEmail('natejacksoninc@gmail.com', 'Nate Jackson', $subject, $content ,"payments@katyrental.com",  $settings['BUSINESS_NAME']);
        sendEmail($customerEmail, $customerName, $CustomerSubject, $customerContent ,'payments@katyrental.com', $settings['BUSINESS_NAME']);

        @header('location: ../orders.php?orderid=00'.$orderdetails_id.'&success=yes');
        echo '<script>window.location.replace("/orders.php?orderid=00'.$orderdetails_id.'&success=yes");</script>';
        exit;

    }catch(\Stripe\Exception\CardException $e) {
        // Since it's a decline, \Stripe\Exception\CardException will be caught
        $customerDeclined = "
        <h2>Payment Receipt : ".$orderdetails_idDesc."</h2>
        <p>Confirmation Number: ".$settings['INVOICE_PRE']."".$token."</p>
        <p>Amount: $".$priceemail."</p>
        <p>Date: ".date("Y-m-d H:i:s")."</p>
        <p>Payment Status: Failed</p>
        <p>Order #: <a href='https://".$settings['DOMAIN']."/orders.php?orderid=00".$orderdetails_id."'>".$orderdetails_idDesc."</a></p>
        Status is:". $e->getHttpStatus()."'\n'
        Type is:". $e->getError()->type ."'\n'
        Code is:". $e->getError()->code ."'\n'
        // param is '' in this case
        Param is:".$e->getError()->param."'\n';
        Message is:". $e->getError()->message ."'\n'";

        sendEmail('kristy.g.jackson@gmail.com', 'Kristy Jackson', $subject, $content, "payments@katyrental.com", $settings['BUSINESS_NAME']);\
        sendEmail('natejacksoninc@gmail.com', 'Nate Jackson', $subject, $content ,"payments@katyrental.com",  $settings['BUSINESS_NAME']);
        @header('location: ../orders.php?orderid=00'.$orderdetails_id.'&error='.$e->getError()->message);
        echo '<script>window.location.replace("/orders.php?orderid=00'.$orderdetails_id.'&error='.$e->getError()->message.'</script>';
        exit;
        }
}else{
   
    @header('location: ../orders.php?orderid=00'.$orderdetails_id);
    exit;
}
