<html lang="en">
    <head>
        <meta charset='utf-8' />
        <title>Event & Party Rental | Chairs & Table Rental</title>
        <meta name="description" content="Looking for affordable chairs & table rentals in the DFW we can Help. Book Today. Get free delivery on all orders over $50 dollars.">
        <!-- Required meta tags -->
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

        <!-- Bootstrap CSS -->
        <link rel="stylesheet" href="assets/lib/bootstrap/css/bootstrap.min.css">

        <!-- Font Awesome -->
        <link href="assets/lib/fontawesome/css/all.css" rel="stylesheet">

        <!-- Custom Styling Sheet-->
        <link href="assets/css/style.css" rel="stylesheet">

        <!-- Google Font-->
        <link href="https://fonts.googleapis.com/css?family=Roboto+Slab|Tangerine&display=swap" rel="stylesheet">

        <!-- Global site tag (gtag.js) - Google Ads: 877394054 -->
        <script async src="https://www.googletagmanager.com/gtag/js?id=AW-877394054"></script>
        <script>
            window.dataLayer = window.dataLayer || [];
            function gtag(){dataLayer.push(arguments);}
            gtag('js', new Date());

            gtag('config', 'AW-877394054');
        </script>

        <!-- Global site tag - Bing Ads Conversions Tracking-->
        <script>(function(w,d,t,r,u){var f,n,i;w[u]=w[u]||[],f=function(){var o={ti:"56001860"};o.q=w[u],w[u]=new UET(o),w[u].push("pageLoad")},n=d.createElement(t),n.src=r,n.async=1,n.onload=n.onreadystatechange=function(){var s=this.readyState;s&&s!=="loaded"&&s!=="complete"||(f(),n.onload=n.onreadystatechange=null)},i=d.getElementsByTagName(t)[0],i.parentNode.insertBefore(n,i)})(window,document,"script","//bat.bing.com/bat.js","uetq");</script>

        <!-- Global site tag (gtag.js) - Google Analytics -->
        <script async src="https://www.googletagmanager.com/gtag/js?id=UA-151576234-1"></script>
        <script>
        window.dataLayer = window.dataLayer || [];
        function gtag(){dataLayer.push(arguments);}
        gtag('js', new Date());

        gtag('config', 'UA-151576234-1');
        </script>

        <style>
        .tangerine{
            font-family: 'Tangerine', cursive;
        }
        .robotoslab{
            font-family: 'Roboto Slab', serif;
        }
        .stripe-button-el{
            display: none !important;
        }
        </style>
        <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
        <script type="text/javascript" src="https://maps.googleapis.com/maps/api/js?key=AIzaSyDCl3n728Zg5Dk7UlsGJeqN8tuxNG-pNZ8&libraries=places"></script>
        <link href='assets/lib/fullcalendar/packages/core/main.css' rel='stylesheet' />
        <link href='assets/lib/fullcalendar/packages/daygrid/main.css' rel='stylesheet' />

        <script src='assets/lib/fullcalendar/packages/core/main.js'></script>
        <script src='assets/lib/fullcalendar/packages/daygrid/main.js'></script>
        <script src='assets/lib/chartjs/dist/Chart.bundle.min.js'></script>
        <script>

            document.addEventListener('DOMContentLoaded', function() {
            var calendarEl = document.getElementById('calendar');

            var calendar = new FullCalendar.Calendar(calendarEl, {
                plugins: [ 'dayGrid' ],
                events: [
                    <?php $getAllReservationPre = getAllOrders("reservation");
                    while ($getAllReservation = $getAllReservationPre->fetch(PDO::FETCH_ASSOC)) {
                    $customerDetailsPre = getCustomerDetail($getAllReservation['CUSTOMER_ID']);
                    $customerDetails = $customerDetailsPre->fetch(PDO::FETCH_ASSOC); 

                    ?>
                    { // this object will be "parsed" into an Event Object
                    id: '<?php echo $customerDetails['ID'];?>',
                    title: 'D: <?php echo $customerDetails['NAME'];?>', // a property!
                    start: '<?php echo $getAllReservation['DELIVERY_DATE'];?>', // a property!
                    end: '<?php echo $getAllReservation['PICKUP_DATE'];?> - <?php echo $getAllReservation['PICKUP_TIME_START'];?>:00', // a property! ** see important note below about 'end' **
                    url: 'https://www.kellyrentals.org/orders.php?orderid=00<?php echo $getAllReservation['ID'];?>',
                    },
                <?php } ?>
                ]
            });

            calendar.render();
            });

        </script>
    </head>
    <body class="main">
        <header>
            <nav class="navbar navbar-expand-lg white-bg navbar-light fixed-top">
                <div class="container">
                    <a class="navbar-brand tangerine" href="#">Kelly Rentals</a>
                    <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarTogglerDemo03" aria-controls="navbarTogglerDemo03" aria-expanded="false" aria-label="Toggle navigation">
                    <span class="navbar-toggler-icon"></span>
                    </button>
                
                    <div class="collapse navbar-collapse robotoslab" id="navbarTogglerDemo03">
                        <ul class="navbar-nav ml-auto">
                            <li class="nav-item">
                                <a class="nav-link" title="View Our Rates" href="#eventdetails">Event</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" title="Get A Quick Quote" href="#items">Items</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" title="Read Our Reviews" href="#payment">Payment</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" title="Call Or Text Us NOW" href="tel:940-220-9422"><i class="fa fa-phone"></i></a>
                            </li>
                        </ul>
                    </div>
                </div>
              </nav>
        </header>
        <?php
            $getCustomerDetailPre = getCustomerDetail($_GET['customer-id']);

            $getCustomerDetail = $getCustomerDetailPre->fetch(PDO::FETCH_ASSOC);
        ?>
        <div class="container " style="margin-top:100px;">
        <nav aria-label="breadcrumb">
              <ol class="breadcrumb">
                <!--li class="breadcrumb-item" aria-current="page"><a href="/dashboard">Home</a></li-->
                <li class="breadcrumb-item" aria-current="page">Customers</li>
                <li class="breadcrumb-item active" aria-current="page"><?php echo $getCustomerDetail['NAME']; ?></li>
            </ol>
            </nav>
            <form class=" row" method="POST" action="/modulus/forms.php" name="editcustomer">                
                <!-- Quotes Table -->
                <div class="col-12 col-md-3 col-lg-3 col-xl-3 pl-0 pr-0">
                    <div class="card col-12 pl-0 pr-0" style="border-radius:0; margin-bottom:40px;"> 
                        <h5 class="card-header">Updates</h5>
                        <div class="card-body">
                            <label for="planner">Event Planner?</label>
                            <select class="form-control" name="planner">
                                <option <?php if( $getCustomerDetail['PLANNER'] == 'no'){echo 'selected';} ?> value="no">No</option>
                                <option <?php if( $getCustomerDetail['PLANNER'] == 'Yes'){echo 'selected';} ?> value="Yes">Yes</option>
                            </select>
                            <label for="taxexempt">Tax Exempt</label>
                            <select class="form-control" name="taxexempt">
                                <option <?php if( $getCustomerDetail['TAX_EXEMPT'] == 'no'){echo 'selected';} ?> value="no">No</option>
                                <option <?php if( $getCustomerDetail['TAX_EXEMPT'] == 'yes'){echo 'selected';} ?> value="yes">Yes</option>
                            </select>
                            <label style="margin-top:20px;" for="status">Status</label>
                            <select class="form-control" name="status">
                                <option <?php if( $getCustomerDetail['STATUS'] == 'DoNotRentToList'){echo 'selected';} ?> value="DoNotRentToList">Do Not Rent To List</option>
                                <option <?php if( $getCustomerDetail['STATUS'] == 'Active'){echo 'selected';} ?> value="Active">Active</option>
                            </select>
                            <label style="margin-top:20px;" for="category">Source</label>
                            <select class="form-control" name="source">
                                <option  <?php if( $getCustomerDetail['SOURCE'] == 'NULL'){echo 'selected';} ?> value="NULL">Other</option>
                                <option  <?php if( $getCustomerDetail['SOURCE'] == 'facebookads'){echo 'selected';} ?> value="facebookads">Facebook ads</option>
                                <option  <?php if( $getCustomerDetail['SOURCE'] == 'Facebook Market Place'){echo 'selected';} ?> value="facebookads">Facebook Market Place</option>
                                <option  <?php if( $getCustomerDetail['SOURCE'] == 'googleads'){echo 'selected';} ?> value="googleads">Google ads</option>
                                <option  <?php if( $getCustomerDetail['SOURCE'] == 'googleplaces'){echo 'selected';} ?> value="googleplaces">Google Places</option>
                                <option  <?php if( $getCustomerDetail['SOURCE'] == 'yelp'){echo 'selected';} ?> value="yelp">Yelp</option>
                            </select>
                            <button type="submit" style="margin-top:20px;" class="btn btn-block btn-secondary">Update Customer</button>
                        </div>
                    </div>
                </div>
                <!-- Inventory Table -->
                <div class="col-12 col-md-9 col-lg-9 col-xl-9 pr-0">
                    <div class="card col-12 pl-0 pr-0" style="border-radius:0; margin-bottom:40px;"> 
                        <h5 class="card-header">Customer Profile</h5>
                        <div class="card-body row" style="">
                            <div class="col-6">
                                <label for="name">Full Name</label>
                                <input name="name" value="<?php echo $getCustomerDetail['NAME']; ?>" class="form-control" placeholder="">
                                <input name="id" value="<?php echo $getCustomerDetail['ID']; ?>" hidden>
                                <input name="form-editcutomer" value="3" hidden>
                            </div>
                            <div class="col-6">
                                <label for="company">Company</label>
                                <input name="company" value="<?php echo $getCustomerDetail['COMPANY']; ?>" class="form-control" placeholder="">
                            </div>
                            <div class="col-6">
                                <label for="email">Email</label>
                                <input name="email" class="form-control" value="<?php echo $getCustomerDetail['EMAIL']; ?>"placeholder="">
                            </div>
                            <div class="col-6">
                                <label for="phone">Phone</label>
                                <input name="phone" class="form-control" value="<?php echo $getCustomerDetail['PHONE']; ?>" placeholder="">
                            </div>
                            <div class="col-6">
                                <label for="ip">IP</label>
                                <input name="ip" class="form-control" value="<?php echo $getCustomerDetail['IP']; ?>"placeholder="" disabled>
                            </div>
                            <div class="col-6">
                                <label for="createddate">Date Added</label>
                                <input name="createddate" class="form-control" value="<?php echo $getCustomerDetail['CREATEDDATE']; ?>" placeholder="" disabled>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-12 pr-0 pl-0">
                    <div class="card col-12 pl-0 pr-0" style="border-radius:0; margin-bottom:40px;"> 
                        <h5 class="card-header">Customer Order</h5>
                        <div class="card-body p-0">
                            <table class="table table-striped mb-0">
                                <thead>
                                    <tr>
                                    <th scope="col">#</th>
                                    <th scope="col">Address</th>
                                    <th scope="col">Status</th>
                                    <th scope="col">Date</th>
                                    <th scope="col">Price</th>
                                    <th scope="col">Edit</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $getordersbyCustomerPre = getordersbyCustomer($getCustomerDetail['ID']);?>
                                    <?php while ($getordersbyCustomer = $getordersbyCustomerPre->fetch(PDO::FETCH_ASSOC)) {?>
                                        <?php $cost = getOrderTotalCost($getordersbyCustomer['ID']); ?>
                                    <tr>
                                        <td><a href="/orders.php?orderid=00<?php echo $getordersbyCustomer['ID']; ?>">KR00<?php echo $getordersbyCustomer['ID']; ?></a></td>
                                        <td><?php echo $getordersbyCustomer['DELIVERY_ADDRESS']; ?></td>
                                        <td><?php echo $getordersbyCustomer['STATUS']; ?></td>
                                        <td><?php echo $getordersbyCustomer['DELIVERY_DATE']; ?></td>
                                        <td>$<?php echo $cost;?></td>
                                        <td><a href="/editorder?orderid=00<?php echo $getordersbyCustomer['ID']; ?>"><i class="fas fa-edit"></i></a></td>
                                    </tr> 
                                    <?php } ?>    
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>